
$(document).ready(function () {
  $("#file").change(function () {
    var fd = new FormData();
    var files = $('#file')[0].files;

    // Check file selected or not
    if (files.length > 0) {
      fd.append('file', files[0]);

      $.ajax({
        url: 'modules/upload_image/upload_image.php',
        type: 'post',
        data: fd,
        contentType: false,
        processData: false,
        success: function (response) {

          var json = $.parseJSON(response);

          if (json.status === 'error') {
            toastr.error(json.errors)
            return false;
          }
          if (json.status === "success") {
            toastr.success(json.success)
            $("#preview_img").attr("src", '../uploads/' + json.image_name);
            $("#file_name").val(json.image_name);
            $(".preview_img").show(); // Display image element
          }
        },
      });
    } else {
      alert("Please select a file.");
    }
  });
});

function delete_detail(id, url) {
  var dataString = 'id=' + id + '&action=delete';

  var x = confirm("Are you sure you want to delete?");
  if (x) {
    $.ajax({
      type: "POST",
      url: url,
      data: dataString,
      cache: false,
      success: function (data) {
        var json = $.parseJSON(data);
        if (json.status === 'success') {
          toastr.success(json.success)
          $(".row_" + id).fadeOut(500);
        }
      }
    });
  } else {
    return false;
  }
}

