<?php
include('includes/database.php');
if (!isset($_SESSION['admin_id'])) {
  header('location: index.php');
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>View Blog | <?php echo $_SESSION['site_setting']['website_title']; ?></title>

  <?php include_once 'includes/header.php'; ?>
</head>

<body class="hold-transition sidebar-mini layout-fixed text-sm">
  <div class="wrapper">

    <?php include_once 'includes/topnav.php'; ?>
    <?php include_once 'includes/leftnav.php'; ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6">
              <h1 class="m-0">View Blog</h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Blog</li>
              </ol>
            </div><!-- /.col -->
          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <!-- Main content -->
      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <!-- left column -->
            <div class="col-md-12">

              <div class="card card-info">
                <div class="card-header">
                  <h3 class="card-title"><i class="fas fa-file-alt"></i> View Blog</h3>
                </div>
                <div class="card-body">
                  <table id="example1" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                        <th>Title</th>
                        <th>Image</th>
                        <th>Action</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      $query = "SELECT * FROM tbl_blog ORDER BY created_date DESC";
                      $result = mysqli_query($db, $query);
                      while ($row = mysqli_fetch_assoc($result)) {
                      ?>
                        <tr class="row_<?php echo $row['id']; ?>">
                          <td><?php echo $row['title']; ?></td>
                          <td><?php echo $row['blog_slug']; ?></td>
                          <td><img src="../uploads/<?php echo $row['image']; ?>" height="100" width="100" /></td>
                          <td>
                            <div class="btn-group btn-group-sm">
                              <a href="blog.php?id=<?php echo base64_encode($row['id']); ?>&action=edit" class="btn btn-info"><i class="fas fa-eye"></i></a>
                              <a href="javascript:void(0);" class="btn btn-danger"><i onclick="delete_detail(<?php echo $row['id']; ?>, 'modules/blog/request.php')" class="fas fa-trash"></i></a>
                            </div>
                          </td>
                        </tr>
                      <?php
                      }
                      ?>
                    </tbody>
                  </table>
                </div>
                <!-- /.card-body -->
              </div>
            </div>
          </div>
          <!-- /.card -->
        </div><!-- /.container-fluid -->
      </section>
      <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <?php include_once 'includes/footer.php'; ?>
  </div>
  <!-- ./wrapper -->

  <?php include_once 'includes/footer_links.php'; ?>
</body>

</html>