<?php
include('includes/database.php');
if (!isset($_SESSION['admin_id'])) {
  header('location: index.php');
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Contact Query | Radico</title>

  <?php include_once 'includes/header.php'; ?>
</head>

<body class="hold-transition sidebar-mini layout-fixed text-sm">
  <div class="wrapper">

    <?php include_once 'includes/topnav.php'; ?>
    <?php include_once 'includes/leftnav.php'; ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6">
              <h1 class="m-0">View Contact Query</h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Contact Query</li>
              </ol>
            </div><!-- /.col -->
          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <!-- Main content -->
      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <!-- left column -->
            <div class="col-md-12">
              <!-- general form elements -->

              <div class="card card-info">
                <div class="card-header">
                  <h3 class="card-title"><i class="fas fa-file-alt"></i> View Contact Query</h3>
                </div>
                <div class="card-body">
                  <table id="example1" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                        <th>Query From</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Mobile</th>
                        <th>Service</th>
                        <th>Message</th>
                        <th>Status</th>
                        <th>Action</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      $query = "SELECT * FROM tbl_contact ORDER BY id DESC";
                      $result = mysqli_query($db, $query);
                      while ($row = mysqli_fetch_assoc($result)) {
                      ?>
                        <tr class="row_<?php echo $row['id']; ?>">
                          <td><?php echo $row['form_page']; ?></td>
                          <td><?php echo $row['name']; ?></td>
                          <td><?php echo $row['email']; ?></td>
                          <td><?php echo $row['mobile']; ?></td>
                          <td><?php echo $row['subject']; ?></td>
                          <td><?php echo $row['message']; ?></td>
                          <td>
                            <?php if ($row['status'] == 'active') { ?>
                              <a href="javascript:void(0);" class="status_<?php echo $row['id']; ?>"><span class="badge bg-success" onclick="change_status(<?php echo $row['id']; ?>, 'inactive', 'modules/contact/request.php')">Active</span></a>
                            <?php } else { ?>
                              <a href="javascript:void(0);" class="status_<?php echo $row['id']; ?>"><span class="badge bg-danger" onclick="change_status(<?php echo $row['id']; ?>, 'active', 'modules/contact/request.php')">Inactive</span></a>
                            <?php } ?>
                          </td>
                          <td>
                            <div class="btn-group btn-group-sm">
                              <a href="javascript:void(0);" class="btn btn-danger"><i onclick="delete_detail(<?php echo $row['id']; ?>, 'modules/contact/request.php')" class="fas fa-trash"></i></a>
                            </div>
                          </td>
                        </tr>
                      <?php
                      }
                      ?>
                    </tbody>
                  </table>
                </div>
                <!-- /.card-body -->
              </div>
            </div>
          </div>
          <!-- /.card -->
        </div><!-- /.container-fluid -->
      </section>
      <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <?php include_once 'includes/footer.php'; ?>
  </div>
  <!-- ./wrapper -->

  <?php include_once 'includes/footer_links.php'; ?>
</body>

</html>