<?php
include('includes/database.php');
if (!isset($_SESSION['admin_id'])) {
  header('location: index.php');
}
$update= 0;
$id = base64_decode($_GET['id']);
if ($_GET['action'] == "edit" && isset($_GET['id'])) {
  $max = "SELECT c.*,cc.name as cat_name,cc.module FROM tbl_course as c LEFT JOIN tbl_course_category as cc ON (cc.id=c.cat_id) WHERE c.id='" . $id . "'";
  $max2 = mysqli_query($db, $max);
  $max3 = mysqli_fetch_assoc($max2);
  extract($max3);
  $update = 1;
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Add Course | <?php echo $_SESSION['site_setting']['website_title']; ?></title>

  <?php include_once 'includes/header.php'; ?>
  <style>
    .custom-control-input {
      position: absolute;
      left: 0;
      z-index: 1;
      width: 2rem;
      height: 2.25rem;
      opacity: 0;
    }
  </style>
</head>

<body class="hold-transition sidebar-mini layout-fixed text-sm">
  <div class="wrapper">

    <?php include_once 'includes/topnav.php'; ?>
    <?php include_once 'includes/leftnav.php'; ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6">
              <h1 class="m-0">Add Course</h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Course</li>
              </ol>
            </div><!-- /.col -->
          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <!-- Main content -->
      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <!-- left column -->
            <div class="col-md-12">
              <!-- general form elements -->
              <div class="card card-primary">
                <div class="card-header">
                  <h3 class="card-title"><i class="fas fa-plus-square"></i> Add Course</h3>
                </div>
                <div class="test"></div>
                <!-- /.card-header -->
                <!-- form start -->
                <form method="post" name="course_form" id="course_form" enctype="multipart/form-data">
                  <input type="hidden" name="courseFormData" value="courseFormData">
                  <input type="hidden" name="id" value="<?php echo $id; ?>">
                  <div class="card-body">
                    <div class="row">
                      <div class="col-md-6">
                        <div class="form-group">
                          <label for="module">Module Name</label>
                          <select class="form-control" id="module" name="module" onchange="getCourseCategory(this.value)">
                            <option value="">Select Option</option>
                            <option <?php if($module=='Zica'){ echo 'selected'; } ?> value="Zica">Zica</option>
                            <option <?php if($module=='Zima'){ echo 'selected'; } ?> value="Zima">Zima</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-6">
                        <div class="form-group">

                          <label for="cat_id">Course Category</label>
                          <select class="form-control" id="cat_id" name="cat_id">
                            <option value="">Select Category</option>
                            <?php if($update==1){
                              $query = "SELECT * FROM tbl_course_category WHERE isActive=1 AND module='".$module."' ORDER BY name ASC";
                              $result = mysqli_query($db, $query);
                              while ($row = mysqli_fetch_assoc($result)) {
                                if($cat_id == $row['id']){  $sel = 'selected'; }else{ $sel = ''; }
                                echo "<option ".$sel." value='".$row['id']."'>".$row['name']."</option>";
                              }
                            } ?>                            
                          </select>
                        </div>
                      </div>
                      <div class="col-md-6">
                        <div class="form-group">
                          <label for="course_name">Course Name</label>
                          <input type="text" class="form-control" id="course_name" name="course_name" placeholder="Course Name" value="<?php echo $course_name; ?>">
                        </div>
                      </div>

                      <div class="col-md-4">
                        <div class="form-group">
                          <label for="name">File</label>
                          <input type="file" class="form-control" accept="image/*" id="file" name="file">
                          <input type="hidden" id="file_name" name="file_name" value="<?php echo $image; ?>">
                        </div>
                      </div>

                      <div class="col-md-2 preview_img" style="display:none;">
                        <img src="" height="100" width="100" id="preview_img" />
                      </div>

                      <div class="col-md-6">
                        <div class="form-group">
                          <label for="course_slug">Course Slug</label>
                          <input type="text" class="form-control" id="course_slug" name="course_slug" placeholder="Course Slug" value="<?php echo $course_slug; ?>">
                        </div>
                      </div>

                      <div class="col-md-6">
                        <div class="form-group">
                          <label for="soft_id">Softwares</label>
                          <select class="form-control select2" multiple="multiple" id="soft_id" name="soft_id[]" data-placeholder="Select Softwares">
                            <option value="">Select Softwares</option>
                            <?php
                              $ex_software_ids  = explode(',', $software_ids);
                              $sql = $db->query("SELECT * FROM tbl_softwares WHERE isActive = '1'");
                              while($row = mysqli_fetch_assoc($sql)){
                                if(in_array($row['id'], $ex_software_ids)){ $sel = 'selected'; }else{ $sel = ''; }
                                echo '<option '.$sel.' value="'.$row['id'].'">'.$row['name'].'</option>';
                              }

                            ?>
                          </select>
                        </div>
                      </div>

                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="description">Small Description</label>
                          <textarea class="form-control" rows="4" id="description" name="description" placeholder="Description"><?php echo $description; ?></textarea>
                        </div>
                      </div>

                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="second_heading">Second Heading</label>
                          <input type="text" class="form-control" id="second_heading" name="second_heading" placeholder="Second Heading" value="<?php echo $second_heading; ?>">
                        </div>
                      </div>

                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="second_description">Second Description</label>
                          <textarea class="form-control" rows="4" id="second_description" name="second_description" placeholder="Second Description"><?php echo $second_description; ?></textarea>
                        </div>
                      </div>

                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="main_content">Main Description</label>
                          <textarea id="summernote1" name="main_content"><?php echo $main_content; ?></textarea>
                        </div>
                      </div>

                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="meta_tags">Meta Tags</label>
                          <textarea class="form-control" rows="4" name="meta_tags"><?php echo html_entity_decode(trim($meta_tags)); ?></textarea>
                        </div>
                      </div>
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="blog_schema">Course Schema</label>
                          <textarea class="form-control" rows="4" name="course_schema"><?php echo html_entity_decode(trim($course_schema)); ?></textarea>
                        </div>
                      </div>
                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="canonical_tags">Canonical Tags</label>
                          <textarea class="form-control" rows="4" name="canonical_tags"><?php echo html_entity_decode(trim($canonical_tags)); ?></textarea>
                        </div>
                      </div>

                    </div>
                  </div>
                  <!-- /.card-body -->
                  <div class="card-footer">
                    <button type="submit" name="submit" class="btn btn-primary">Submit</button>
                  </div>
                </form>
              </div>

            </div>
          </div>
          <!-- /.card -->
        </div><!-- /.container-fluid -->
      </section>
      <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <?php include_once 'includes/footer.php'; ?>
  </div>
  <!-- ./wrapper -->

  <?php include_once 'includes/footer_links.php'; ?>

  <script>
    $(document).ready(function () {
      $('#course_form').bootstrapValidator({
        message: 'This value is not valid',
        // feedbackIcons: {
        //   valid: 'fa fa-check',
        //   invalid: 'fa fa-times',
        //   validating: 'fa fa-refresh'
        // },
        fields: {
          module: {
            group: '.form-group',
            validators: {
              notEmpty: {
                message: 'Required'
              }
            }
          },
          cat_id: {
            group: '.form-group',
            validators: {
              notEmpty: {
                message: 'Required'
              }
            }
          },
          course_name: {
            group: '.form-group',
            validators: {
              notEmpty: {
                message: 'Required'
              }
            }
          },
          course_slug: {
            group: '.form-group',
            validators: {
              notEmpty: {
                message: 'Required'
              }
            }
          },
          description: {
            group: '.form-group',
            validators: {
              notEmpty: {
                message: 'Required'
              }
            }
          },
        }
      }).on('success.form.bv', function(e) {
        e.preventDefault();
        var record = $('#course_form').serialize();
        $('#course_form').bootstrapValidator("resetForm", true);
        $.ajax({
          type: "POST",
          url: "modules/course/request.php",
          data: record,
          success: function(response) {
            var r = JSON.parse(response);
            if (r.response == 1) {
              $('#course_form').bootstrapValidator("resetForm", true);
              toastr.success(r.success);
              location.href = 'view_course.php';
            } else {
              toastr.error(r.errors);
              return false;
            }
          },
        });
      });
    });

    function getCourseCategory(value){
      $.ajax({
        type: "POST",
        url: "includes/fetch.php",
        data: {
          getCourseCategory: 'getCourseCategory',
          module: value
        },
        success: function(response) {
          $("#cat_id").html(response);
        },
      });
    }

    $('#summernote1').summernote({
      height: 300,
      lineWrapping: true,
    });
  </script>
</body>

</html>