<?php
  include_once('includes/database.php');
  if (!isset($_SESSION['admin_id'])) {
    header('location: login.php');
  }

  if(isset($_GET['p'])){
    $updateID = base64_decode($_GET['p']);

    $sqlQuery = mysqli_query($db, "SELECT * FROM tbl_property WHERE id = '".$updateID."' AND isActive = 1");
    $row  = mysqli_fetch_assoc($sqlQuery);
    extract($row);
    $ex_amenities = explode(',', $amenities);    
  }
?>

<!doctype html>
<html lang="en" data-layout="<?php echo $data_layout; ?>" data-topbar="<?php echo $data_topbar; ?>" data-sidebar="<?php echo $data_sidebar; ?>" data-sidebar-size="<?php echo $data_sidebar_size; ?>" data-sidebar-image="<?php echo $data_sidebar_image; ?>" data-preloader="<?php echo $data_preloader; ?>">

<head>

  <meta charset="utf-8" />
  <title>Update Property | Website Name</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
  <meta content="Themesbrand" name="author" />

  <?php include_once('includes/header_links.php'); ?>

</head>

<body>

  <!-- Begin page -->
  <div id="layout-wrapper">

    <?php include_once('includes/top_menu.php'); ?>
    <?php include_once('includes/left_menu.php'); ?>

    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

      <div class="page-content">
        <div class="container-fluid">

          <!-- start page title -->
          <div class="row">
            <div class="col-12">
              <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Update Property</h4>

                <div class="page-title-right">
                  <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript: void(0);">Property Manage</a></li>
                    <li class="breadcrumb-item active">Update Property</li>
                  </ol>
                </div>

              </div>
            </div>
          </div>
          <!-- end page title -->

          <div class="row">
            <div class="col-lg-12">
              <div class="card">
                <form method="post" id="PropertyForm" enctype="multipart/form-data">
                  <input type="hidden" name="AddProperty" value="AddProperty">
                  <input type="hidden" name="UpdateID" value="<?php echo $updateID; ?>">

                  <div class="card-header">
                    <h5 class="card-title mb-0"><?php echo $UpdateProperty; ?></h5>
                  </div>
                  <div class="card-body">
                    <div class="row g-4">
                      <div class="col-lg-6">
                        <label class="form-label">Property Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="property_name" id="property_name" placeholder="Property Name" value="<?php echo $property_name; ?>" required />
                      </div>
                      <div class="col-lg-6">
                        <label class="form-label">Property Slug <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="up_property_slug" id="up_property_slug" placeholder="Property Slug" value="<?php echo $property_slug; ?>" required />
                      </div>
                      <div class="col-lg-6">
                        <label class="form-label">Property Image </label>
                        <input type="file" class="form-control" name="property_image" id="property_image" accept=".jpg,.jpeg,.png,.webp" />
                      </div>
                      <div class="col-lg-6">
                        <label class="form-label">Property Image Multiple</label>
                        <input type="file" class="form-control" name="p_multi_image[]" multiple id="p_multi_image" accept=".jpg,.jpeg,.png,.webp" />
                      </div>
                      <div class="col-lg-6">
                        <label class="form-label">Property Floor Plan</label>
                        <input type="file" class="form-control" name="floor_plan" id="floor_plan" accept=".pdf" />
                      </div>
                      <div class="col-lg-6">
                        <label class="form-label">Property Brochure</label>
                        <input type="file" class="form-control" name="brochure" id="brochure" accept=".pdf" />
                      </div>
                      <div class="col-lg-6">
                        <label class="form-label">Video Thumbnail</label>
                        <input type="file" class="form-control" name="video_thumbnail" id="video_thumbnail" accept=".jpg,.jpeg,.png,.webp" />
                      </div>
                      <div class="col-lg-12">
                        <label class="form-label">Meta Tags</label>
                        <textarea class="form-control" name="meta_tags" id="meta_tags" rows="4" placeholder="Meta Tags"><?php echo $meta_tags; ?></textarea>
                      </div>
                      <div class="col-lg-12">
                        <label class="form-label">Schema</label>
                        <textarea class="form-control" name="schema_content" id="schema_content" rows="4" placeholder="Schema"><?php echo $schema_content; ?></textarea>
                      </div>
                      <div class="col-lg-12">
                        <label class="form-label">Property Video </label>
                        <input type="text" class="form-control" name="property_video" id="property_video" placeholder="Property Video" value="<?php echo $property_video; ?>" />
                      </div>
                      <div class="col-lg-12">
                        <label class="form-label">Map Location (URL)</label>
                        <textarea class="form-control" name="map_location" id="map_location" rows="3" placeholder="Enter Map Location"><?php echo $map_location; ?></textarea>
                      </div>

                      <div class="col-lg-6">
                        <label class="form-label">Country <span class="text-danger">*</span></label>
                        <select class="form-control" name="country" onchange="FetchState(this)" required>
                          <option value="">Select Country</option>
                          <?php echo selectedCountry($country); ?>
                        </select>
                      </div>
                      <div class="col-lg-6">
                        <label class="form-label">State <span class="text-danger">*</span></label>
                        <select class="form-control" name="state" onchange="FetchCity(this)" required>
                          <option value="">Select State</option>
                          <?php
                          if(!empty($state)){
                            $sqlState = mysqli_query($db, "SELECT * FROM tbl_state WHERE isActive = 1 AND country_id = '".$country."'");
                            if(mysqli_num_rows($sqlState)>0){
                              while($fetchState = mysqli_fetch_assoc($sqlState)){
                                if($fetchState['id']==$state){  $selected = "selected"; }else{  $selected =  ''; }
                            ?>
                              <option <?php echo $selected; ?> value="<?php echo $fetchState['id']; ?>"><?php echo $fetchState['name']; ?></option>
                            <?php
                              }
                            }
                          }
                          ?>
                        </select>
                      </div>
                      <div class="col-lg-6">
                        <label class="form-label">City <span class="text-danger">*</span></label>
                        <select class="form-control" name="city" required>
                          <option value="">Select City</option>
                          <?php
                          if(!empty($city)){
                            $sqlCity = mysqli_query($db, "SELECT * FROM tbl_city WHERE isActive = 1 AND country_id = '".$country."' AND state_id = '".$state."'");
                            if(mysqli_num_rows($sqlCity)>0){
                              while($fetchCity = mysqli_fetch_assoc($sqlCity)){
                                if($fetchCity['id']==$city){  $selected = "selected"; }else{  $selected =  ''; }
                            ?>
                              <option <?php echo $selected; ?> value="<?php echo $fetchCity['id']; ?>"><?php echo $fetchCity['name']; ?></option>
                            <?php
                              }
                            }
                          }
                          ?>
                        </select>
                      </div>
                      <div class="col-lg-6">
                        <label class="form-label">Address <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="address" id="address" placeholder="Enter Address" value="<?php echo $address; ?>" required />
                      </div>
                      <div class="col-lg-6">
                        <label class="form-label">Zipcode <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="zipcode" id="zipcode" placeholder="Enter Zipcode" value="<?php echo $zipcode; ?>" required />
                      </div>
                      <div class="col-lg-6">
                        <label class="form-label">Category <span class="text-danger">*</span></label>
                        <select class="form-control" name="category" required>
                          <option value="">Select Category</option>
                          <?php selectedCategory($category) ?>
                        </select>
                      </div>
                      <div class="col-lg-6">
                        <label class="form-label">Property Type <span class="text-danger">*</span></label>
                        <select class="form-control" name="property_type" onchange="ChangePropertyType(this.value)" required>
                          <option value="">Select Type</option>
                          <option <?php if($property_type=='Residential'){ echo "selected";  } ?> value="Residential">Residential</option>
                          <!-- <option <?php if($property_type=='Rental'){ echo "selected";  } ?> value="Rental">Rental</option> -->
                        </select>
                      </div>

                      <div class="col-lg-6 rental_div" style="display:none";>
                        <label class="form-label">Rental Payout</label>
                        <select class="form-control" name="rental_payout">
                          <option value="">Select Rental Payout</option>
                          <option <?php if($rental_payout=='Monthly'){ echo "selected";  } ?> value="Monthly">Monthly</option>
                          <option <?php if($rental_payout=='Quarterly'){ echo "selected";  } ?> value="Quarterly">Quarterly</option>
                          <option <?php if($rental_payout=='Half Yearly'){ echo "selected";  } ?> value="Half Yearly">Half Yearly</option>
                          <option <?php if($rental_payout=='Yearly'){ echo "selected";  } ?> value="Yearly">Yearly</option>
                        </select>
                      </div>
                      <div class="col-lg-6 rental_div" style="display:none;">
                        <label class="form-label">Rental Price</label>
                        <input type="text" class="form-control" name="rental_price" id="rental_price" placeholder="Enter Rental Price" value="<?php echo $rental_price; ?>" />
                      </div>

                      
                      <div class="col-lg-12">
                        <label class="form-label">Description <span class="text-danger">*</span></label>
                        <textarea name="description" required id="editor"><?php echo $description; ?></textarea>
                      </div>

                      <div class="col-lg-4">
                        <label class="form-label">Price</label>
                        <input type="text" class="form-control" id="price" name="price" placeholder="Price" value="<?php echo $price; ?>" />
                      </div>
                      <div class="col-lg-4">
                        <label class="form-label"> Property Size</label>
                        <input type="text" class="form-control" id="size" name="size" placeholder="Property Size" value="<?php echo $size; ?>" />
                      </div>
                      <div class="col-lg-4">
                        <label class="form-label"> Rooms</label>
                        <input type="text" class="form-control" id="rooms" name="rooms" placeholder="Rooms" value="<?php echo $rooms; ?>" />
                      </div>
                      <div class="col-lg-4">
                        <label class="form-label"> Bedrooms</label>
                        <input type="text" class="form-control" id="bedrooms" name="bedrooms" placeholder="Bedrooms" value="<?php echo $bedrooms; ?>" />
                      </div>
                      <div class="col-lg-4">
                        <label class="form-label"> Bathrooms</label>
                        <input type="text" class="form-control" id="bathrooms" name="bathrooms" placeholder="Bathrooms" value="<?php echo $bathrooms; ?>" />
                      </div>
                      <div class="col-lg-4">
                        <label class="form-label"> Parking Area</label>
                        <input type="text" class="form-control" id="parking_area" name="parking_area" placeholder="Parking Area" value="<?php echo $parking_area; ?>" />
                      </div>
                      <div class="col-lg-4">
                        <label class="form-label"> Year Built</label>
                        <input type="text" class="form-control yearpicker" id="year_built" name="year_built" placeholder="Year Built" value="<?php echo $year_built; ?>" />
                      </div>
                      <div class="col-lg-4">
                        <label class="form-label"> Available From</label>
                        <input type="text" class="form-control date_picker" id="available_from" name="available_from" placeholder="Available From" value="<?php echo $available_from; ?>" />
                      </div>
                      <div class="col-lg-4">
                        <label class="form-label"> Structure Type</label>
                        <input type="text" class="form-control" id="structure_type" name="structure_type" placeholder="Structure Type" value="<?php echo $structure_type; ?>" />
                      </div>
                      <div class="col-lg-4">
                        <label class="form-label"> Floors No</label>
                        <input type="text" class="form-control" id="floor_no" name="floor_no" placeholder="Floors No" value="<?php echo $floor_no; ?>" />
                      </div>

                      <div class="col-lg-12">
                        <hr />
                        <h5 class="card-title mb-0">Aminities</h5>
                        <hr />
                        <?php //print_r($ex_amenities); ?>
                      </div>

                      <?php
                      $sqlAmenity = mysqli_query($db, "SELECT * FROM tbl_amenities WHERE isActive = 1");
                      if(mysqli_num_rows($sqlAmenity)>0){
                        while($fetchAmenity = mysqli_fetch_assoc($sqlAmenity)){
                          if(in_array($fetchAmenity['id'], $ex_amenities)){ $checked  = 'checked';  }else{  $checked  = ''; }
                          ?>
                          <div class="col-lg-3">
                            <div class="form-check form-switch">
                              <input class="form-check-input" type="checkbox" <?php echo $checked; ?> role="switch" name="amenities[]" value="<?php echo $fetchAmenity['id']; ?>">
                              <label class="form-check-label"><?php echo $fetchAmenity['aminity_name']; ?></label>
                            </div>
                          </div>
                          <?php
                        }
                      }
                      ?>

                      <div class="col-lg-12">
                        <div class="hstack justify-content-end gap-2">
                          <button type="submit" name="submit" class="btn btn-primary">Submit</button>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>

        </div>
        <!-- container-fluid -->
      </div>
      <!-- End Page-content -->

      <?php include_once('includes/footer.php'); ?>
    </div>
    <!-- end main content-->

  </div>
  <!-- END layout-wrapper -->

  <?php include_once('includes/footer_links.php'); ?>

  <script>
    $(document).ready(function() {
      $('#PropertyForm').bootstrapValidator({
        // excluded: [':disabled'],
        message: 'This value is not valid',
        feedbackIcons: {
          valid: 'fa fa-check',
          invalid: 'fa fa-times',
          validating: 'fa fa-refresh'
        },
        fields: {
          'property_name': {
            group: '.col-lg-6',
            validators: {
              notEmpty: {
                message: 'This Field is required'
              },
            }
          },
          'up_property_slug': {
            group: '.col-lg-6',
            validators: {
              notEmpty: {
                message: 'This Field is required'
              },
              regexp: {
                regexp: /^[a-z0-9 -]*$/g,
                message: 'Enter vaild slug'
              },
              // remote: {
              //   type: 'POST',
              //   url: 'includes/remote.php',
              //   message: 'This slug already exists try again !!',
              //   delay: 1000
              // },
            }
          },
          'country': {
            group: '.col-lg-6',
            validators: {
              notEmpty: {
                message: 'This Field is required'
              },
            }
          },
          'state': {
            group: '.col-lg-6',
            validators: {
              notEmpty: {
                message: 'This Field is required'
              },
            }
          },
          'city': {
            group: '.col-lg-6',
            validators: {
              notEmpty: {
                message: 'This Field is required'
              },
            }
          },
          'address': {
            group: '.col-lg-6',
            validators: {
              notEmpty: {
                message: 'This Field is required'
              },
            }
          },
          'zipcode': {
            group: '.col-lg-6',
            validators: {
              notEmpty: {
                message: 'This Field is required'
              },
            }
          },
          'category': {
            group: '.col-lg-6',
            validators: {
              notEmpty: {
                message: 'This Field is required'
              },
            }
          },
          'property_type': {
            group: '.col-lg-6',
            validators: {
              notEmpty: {
                message: 'This Field is required'
              },
            }
          },
          'description': {
            group: '.col-lg-12',
            validators: {
              notEmpty: {
                message: 'This Field is required'
              },
            }
          },
        }
      })
      .on('success.form.bv', function(e) {
        e.preventDefault();
        // var record = $('#PropertyForm').serialize();
        $.ajax({
          type: "POST",
          url: "modules/property/request.php",
          // cache: false,
          // contentType: false,
          // processData: false,
          // dataType: "html",
          // data: record,
          // data: new FormData(),
          data: new FormData($('#PropertyForm')[0]),
          dataType: 'html',
          contentType: false,
          cache: false,
          processData: false,
          success: function (response) { 
            var data = JSON.parse(response);

            if(data.response == 1){
              $('#PropertyForm').bootstrapValidator("resetForm",true); 
              
              Swal.fire(
                'Property Updated Successfully',
                '',
                'success'
              ).then((result) => {
                location.href = 'viewProperty.php';
              });
            }else{
              $('#PropertyForm').bootstrapValidator("resetForm",true); 
              
              Swal.fire(
                'Opps Something Went Wrong',
                '',
                'error'
              )
            }
          },
        });
      });
    });

    <?php if(!empty($property_type)){  ?>
      ChangePropertyType('<?php echo $property_type; ?>');
    <?php } ?>

    function ChangePropertyType(value){
      if(value=='Rental'){
        $(".rental_div").show();
      }else{
        $(".rental_div").hide();
      }
    }

    function FetchState(element){
      var CountryID = $(element).val();
      $("select[name='city']").html('<option value="">Select City</option>');
      $.ajax({
        type: "POST",
        url: "includes/fetch.php",
        dataType: "html",
        data: {
          getStates: 'getStates',
          CountryID: CountryID
        },
        success: function(response) {
          $("select[name='state']").html(response);
        }
      });
    }

    function FetchCity(element){
      var StateID = $(element).val();
      var CountryID = $("select[name='country']").val();
      $.ajax({
        type: "POST",
        url: "includes/fetch.php",
        dataType: "html",
        data: {
          getCity: 'getStates',
          CountryID: CountryID,
          StateID: StateID,
        },
        success: function(response) {
          $("select[name='city']").html(response);
        }
      });
    }

  </script>
</body>

</html>