<?php

include_once '../../includes/database.php';
$errorMsg = array();
$success = array();


if (isset($_FILES['file']['name'])) {

  /* Getting file name */
  $fileName = $_FILES['file']['name'];
  $tempPath = $_FILES['file']['tmp_name'];
  $fileSize = $_FILES['file']['size'];
  $upload_path = "../../../uploads/";

  $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION)); // get image extension

  $file = time() . '.' . $fileExt;

  /* Valid extensions */
  $valid_extensions = array("jpg", "jpeg", "png");

  // allow valid image file formats
  if (in_array($fileExt, $valid_extensions)) {
    //check file not exist our upload folder path
    if (!file_exists($upload_path . $fileName)) {
      // check file size '5MB'
      if ($fileSize < 5000000) {
        move_uploaded_file($tempPath, $upload_path . $file); // move file from system temporary path to our upload folder path 
        echo json_encode(array('status' => 'success', 'success' => 'Uploaded Successfully', 'image_name' => $file));
      } else {
        $errorMsg[] = "Sorry, your file is too large, please upload 5 MB size";
      }
    } else {
      $errorMsg[] = "Sorry, file already exists check upload folder";
    }
  } else {
    $errorMsg[] = "Sorry, only JPG, JPEG, PNG files are allowed";
  }


  if (count($errorMsg) > 0) {
    echo json_encode(array('status' => 'error', 'errors' => $errorMsg));
  }
}
