<?php
include('includes/database.php');
if (!isset($_SESSION['admin_id'])) {
  header('location: index.php');
}
$action = 'submit';
$id = base64_decode($_GET['id']);
if ($_GET['action'] == "edit" && isset($_GET['id'])) {
  $max = "select * from tbl_event where id='" . $id . "'";
  $max2 = mysqli_query($db, $max);
  $max3 = mysqli_fetch_assoc($max2);
  extract($max3);
  $update = 1;
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Events | <?php echo $_SESSION['site_setting']['website_title']; ?></title>

  <?php include_once 'includes/header.php'; ?>
</head>

<body class="hold-transition sidebar-mini layout-fixed text-sm">
  <div class="wrapper">

    <?php include_once 'includes/topnav.php'; ?>
    <?php include_once 'includes/leftnav.php'; ?>

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6">
              <h1 class="m-0">Add / View Events</h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Events</li>
              </ol>
            </div><!-- /.col -->
          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <!-- Main content -->
      <section class="content">
        <div class="container-fluid">
          <div class="row">
            <!-- left column -->
            <div class="col-md-12">
              <!-- general form elements -->
              <div class="card card-primary">
                <div class="card-header">
                  <h3 class="card-title"><i class="fas fa-plus-square"></i> Add Events</h3>
                </div>
                <div class="test"></div>
                <!-- /.card-header -->
                <!-- form start -->
                <form method="post" name="event_form" id="event_form" enctype="multipart/form-data">
                  <input type="hidden" name="action" value="<?php echo $action; ?>">
                  <input type="hidden" name="id" value="<?php echo $id; ?>">
                  <input type="hidden" name="eventFormData" value="eventFormData">
                  <div class="card-body">
                    <div class="row">
                      <div class="col-md-5">
                        <div class="form-group">
                          <label for="title">Title</label>
                          <input type="text" class="form-control" id="title" name="title" placeholder="Title" value="<?php echo $title; ?>">
                        </div>
                      </div>
                      
                      <div class="col-md-5">
                        <div class="form-group">
                          <label for="name">File</label>
                          <input type="file" class="form-control" accept="image/*" id="file" name="file">

                          <input type="hidden" id="file_name" name="file_name" value="<?php echo $image; ?>">
                        </div>
                      </div>

                      <div class="col-md-2 preview_img" style="display:none;">
                        <img src="" height="100" width="100" id="preview_img" />
                      </div>

                      <div class="col-md-5" >
                        <div class="form-group">
                          <label for="name">Video Type</label>
                          <select class="form-control" id="video_type" name="video_type" onchange="videoType(this.value)">
                            <option value="">Select Type</option>
                            <option value="Upload Video">Upload Video</option>
                            <option value="Video Link">Video Link</option>
                          </select>
                        </div>
                      </div>

                      <div class="col-md-7 video_div" style="display:none;">
                        <div class="form-group">
                          <label for="name">Video</label>
                          <input type="file" class="form-control" accept="video/*" id="event_video" name="event_video">
                        </div>
                      </div>

                      <div class="col-md-7 video_url_div" style="display:none;">
                        <div class="form-group">
                          <label for="name">Youtube Video Link</label>
                          <input type="text" class="form-control" id="video_url" name="video_url" placeholder="Youtube Video Link">
                        </div>
                      </div>

                      <div class="col-md-12">
                        <div class="form-group">
                          <label for="description">Description</label>
                          <textarea id="summernote1" name="description"><?php echo $description; ?></textarea>
                        </div>
                      </div>
                    </div>
                  </div>
                  <!-- /.card-body -->
                  <div class="card-footer">
                    <button type="submit" name="submit" class="btn btn-primary">Submit</button>
                  </div>
                </form>
              </div>

              <div class="card card-info">
                <div class="card-header">
                  <h3 class="card-title"><i class="fas fa-file-alt"></i> View Events</h3>
                </div>
                <div class="card-body">
                  <table id="example1" class="table table-bordered table-striped">
                    <thead>
                      <tr>
                        <th>Title</th>
                        <th>Image</th>
                        <th>Action</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      $query = "SELECT * FROM tbl_event ORDER BY created_date DESC";
                      $result = mysqli_query($db, $query);
                      while ($row = mysqli_fetch_assoc($result)) {
                      ?>
                        <tr class="row_<?php echo $row['id']; ?>">
                          <td><?php echo $row['title']; ?></td>
                          <td><img src="../uploads/<?php echo $row['image']; ?>" height="100" width="100" /></td>
                          <td>
                            <div class="btn-group btn-group-sm">
                              <a href="events.php?id=<?php echo base64_encode($row['id']); ?>&action=edit" class="btn btn-info"><i class="fas fa-eye"></i></a>
                              <a href="javascript:void(0);" class="btn btn-danger"><i onclick="delete_detail(<?php echo $row['id']; ?>, 'modules/events/request.php')" class="fas fa-trash"></i></a>
                            </div>
                          </td>
                        </tr>
                      <?php
                      }
                      ?>
                    </tbody>
                  </table>
                </div>
                <!-- /.card-body -->
              </div>
            </div>
          </div>
          <!-- /.card -->
        </div><!-- /.container-fluid -->
      </section>
      <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->
    <?php include_once 'includes/footer.php'; ?>
  </div>
  <!-- ./wrapper -->

  <?php include_once 'includes/footer_links.php'; ?>
  <script>
    $(document).ready(function () {
      $('#event_form').bootstrapValidator({
        message: 'This value is not valid',
        // feedbackIcons: {
        //   valid: 'fa fa-check',
        //   invalid: 'fa fa-times',
        //   validating: 'fa fa-refresh'
        // },
        fields: {
          title: {
            group: '.form-group',
            validators: {
              notEmpty: {
                message: 'Required'
              }
            }
          },
        }
      }).on('success.form.bv', function(e) {
        e.preventDefault();
        // var record = $('#event_form').serialize();
        // $('#event_form').bootstrapValidator("resetForm", true);
        var form_data = new FormData($(this)[0]);

        $.ajax({
          type: "POST",
          url: "modules/events/request.php",
          // data: record,
          data: form_data,
          dataType: 'html',
          contentType: false,
          processData: false,
          success: function(response) {
            var json = $.parseJSON(response);

            if (json.status === 'error') {
              toastr.error(json.errors)
              return false;
            }
            if (json.status === "success") {
              $('#event_form').bootstrapValidator("resetForm", true);
              toastr.success(json.success)
              $('#event_form')[0].reset();
              $('#summernote1').summernote('reset');
              $("#preview_img").attr("src", '');
              $(".preview_img").hide();
              location.href = 'events.php';
            }

          },
        });
      });
    });

    $('#summernote1').summernote({
      height: 300,
      lineWrapping: true,
    });

    function videoType(value){
      if(value=='Upload Video'){
        $(".video_url_div").hide();
        $(".video_url_div input").val('');
        $(".video_div").show();
      }else if(value=='Video Link'){
        $(".video_div").hide();
        $(".video_div input").val('');
        $(".video_url_div").show();
        
      }else{
        $(".video_url_div").hide();
        $(".video_div").hide();
        $(".video_url_div input").val('');
        $(".video_div input").val('');
      }
    }
  </script>
</body>

</html>