<?php
  include_once('includes/database.php');
  if (!isset($_SESSION['admin_id'])) {
    header('location: login.php');
  }
?>

<!doctype html>
<html lang="en" data-layout="<?php echo $data_layout; ?>" data-topbar="<?php echo $data_topbar; ?>" data-sidebar="<?php echo $data_sidebar; ?>" data-sidebar-size="<?php echo $data_sidebar_size; ?>" data-sidebar-image="<?php echo $data_sidebar_image; ?>" data-preloader="<?php echo $data_preloader; ?>">

<head>

  <meta charset="utf-8" />
  <title>Add Blog | Website Name</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
  <meta content="Themesbrand" name="author" />

  <?php include_once('includes/header_links.php'); ?>
  <style>
    .ck-editor__editable[role="textbox"] {
        /* editing area */
        min-height: 200px;
    }
    .ck-content .image {
        /* block images */
        max-width: 80%;
        margin: 20px auto;
    }
  </style>
</head>

<body>

  <!-- Begin page -->
  <div id="layout-wrapper">

    <?php include_once('includes/top_menu.php'); ?>
    <?php include_once('includes/left_menu.php'); ?>

    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

      <div class="page-content">
        <div class="container-fluid">

          <!-- start page title -->
          <div class="row">
            <div class="col-12">
              <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Add Blog</h4>

                <div class="page-title-right">
                  <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="javascript: void(0);">Blog Manage</a></li>
                    <li class="breadcrumb-item active">Add Blog</li>
                  </ol>
                </div>

              </div>
            </div>
          </div>
          <!-- end page title -->

          <div class="row">
            <div class="col-lg-12">
              <div class="card">
                <form method="post" id="BlogForm" enctype="multipart/form-data">
                  <input type="hidden" name="AddBlog" value="AddBlog">
                  <div class="card-header">
                    <h5 class="card-title mb-0">Create Blog</h5>
                  </div>
                  <div class="card-body">
                    <div class="row g-4">
                      <div class="col-lg-6">
                        <label class="form-label">Blog Title <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="title" name="title" placeholder="Enter Title" required />
                      </div>
                      <div class="col-lg-6">
                        <label class="form-label">Blog Slug <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="blog_slug" name="blog_slug" placeholder="Blog Slug" required />
                      </div>
                      <div class="col-lg-6">
                        <label class="form-label">Category <span class="text-danger">*</span></label>
                        <select class="form-control" name="category_id" required>
                          <option value="">Select Category</option>
                          <?php showBlogCategory() ?>
                        </select>
                      </div>
                      <div class="col-lg-6">
                        <label class="form-label">Image <span class="text-danger">*</span></label>
                        <input type="file" class="form-control" id="image" name="image" required />
                      </div>
                      <div class="col-lg-12">
                        <label class="form-label">Meta Tags </label>
                        <textarea class="form-control" id="meta_tags" name="meta_tags" rows="3" placeholder="Enter Meta Tags"></textarea>
                      </div>
                      <div class="col-lg-12">
                        <label class="form-label">Schema Content</label>
                        <textarea class="form-control" id="schema_content" name="schema_content" rows="3" placeholder="Enter Schema Content"></textarea>
                      </div>
                      <div class="col-lg-12">
                        <label class="form-label">Small Description <span class="text-danger">*</span></label>
                        <textarea class="form-control" id="small_desc" name="small_desc" rows="3" placeholder="Small Description" required></textarea>
                      </div>
                      <div class="col-lg-12">
                        <label class="form-label">Blog Description <span class="text-danger">*</span></label>
                        <textarea id="editor" name="description"></textarea>
                        
                      </div>
                    
                      <div class="col-lg-12">
                        <div class="hstack justify-content-end gap-2">
                          <button type="submit" name="submit" class="btn btn-primary">Submit</button>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>

        </div>
        <!-- container-fluid -->
      </div>
      <!-- End Page-content -->

      <?php include_once('includes/footer.php'); ?>
    </div>
    <!-- end main content-->

  </div>
  <!-- END layout-wrapper -->

  <?php include_once('includes/footer_links.php'); ?>

  <script>
    $(document).ready(function() {
      $('#BlogForm').bootstrapValidator({
        // excluded: [':disabled'],
        message: 'This value is not valid',
        feedbackIcons: {
          valid: 'fa fa-check',
          invalid: 'fa fa-times',
          validating: 'fa fa-refresh'
        },
        fields: {
          'title': {
            group: '.col-lg-6',
            validators: {
              notEmpty: {
                message: 'This Field is required'
              },
            }
          },
          'blog_slug': {
            group: '.col-lg-6',
            validators: {
              notEmpty: {
                message: 'This Field is required'
              },
              // regexp: {
              //   // regexp: /^[a-z0-9 -]*$/g,
              //   // regexp: /^[a-z\d\-+_]*$/g,
              //   message: 'Enter vaild slug'
              // },
            }
          },
          'category_id': {
            group: '.col-lg-6',
            validators: {
              notEmpty: {
                message: 'This Field is required'
              },
            }
          },
          'image': {
            group: '.col-lg-6',
            validators: {
              notEmpty: {
                message: 'This Field is required'
              },
            }
          },
          'small_desc': {
            group: '.col-lg-12',
            validators: {
              notEmpty: {
                message: 'This Field is required'
              },
            }
          },
          // 'description': {
          //   group: '.col-lg-12',
          //   validators: {
          //     notEmpty: {
          //       message: 'This Field is required'
          //     },
          //   }
          // },
        }
      })
      .on('success.form.bv', function(e) {
        e.preventDefault();
        $.ajax({
          type: "POST",
          url: "modules/blog/request.php",
          data: new FormData($('#BlogForm')[0]),
          dataType: 'html',
          contentType: false,
          cache: false,
          processData: false,
          beforeSend: function() {
            $("#preloader").show();
          },
          success: function (response) { 
            var data = JSON.parse(response);

            if(data.response == 1){
              $("#preloader").hide();
              $('#BlogForm').bootstrapValidator("resetForm",true); 
              
              Swal.fire(
                'Blog Added Successfully',
                '',
                'success'
              ).then((result) => {
                location.href = 'viewBlog.php';
              });
            }else{
              $('#BlogForm').bootstrapValidator("resetForm",true); 
              
              Swal.fire(
                'Opps Something Went Wrong',
                '',
                'error'
              )
            }
          },
        });
      });
    });


  </script>
</body>

</html>